# Flow Reconstruction GNNs
Official implementation of flow reconstruction GNNs paper submitted to ICLR 2023

# Requirements
Please make sure you have the following python packages installed

* python>=3.9
* numpy>=1.22.4
* torch>=1.11.0
* torch-geometric>=2.1.0
* names-generator>=0.1.0
* python-box>=6.0.2
* matplotlib>=3.5.2
* networkx>=2.8.2

# Downloading the dataset
The dataset used to train, validate and test the flow reconstruction GNNs can be downloaded [here](https://doi.org/10.5281/zenodo.6583995).

# Training 
First update the `config.yml` yaml file, used to set the dataset paths, hyperparams and model architecture.

Training can be started with:
`python train.py -c path/to/config.yml -r /path/to/run_folder`

# Testing
To test a trained model (best version recorded during training) use the following command (which also plots the final test sample):
`python test.py -d /path/to/run_folder/run_name -v best -t path/to/test_dataset.zip -p`