import numpy as np

def mod_add(x,y,p):
    z = x+y
    if z>p or z==p:
        z=z-p
    return z

def mod_sum(a, p):
    r=0
    for x in a:
        r=mod_add(r,x,p)
    return r

def mod_mult(x,y,p):
    r = x*y
    if r<p :
        return r
    else:
        return r-(r//p)*p

def mod_dot(a, b, p):
    r=np.array([])
    for i in range(len(a)):
        r = np.append(r, mod_mult(a[i], b[i], p))
    return r

def mod_sub(x,y,p):
    z = x-y
    if z>p or z==p:
        z=z-p
    if z<0:
        z=z+p
    return z

def mod_neg(x,p):
    z=p-x
    if z>p or z==p:
        z=z-p
    if z<0:
        z=z+p
    return z


def convert_to_field(x, p):
    if x<0:
        return p+x
    else:
        return x

def convert_to_fixed(x, p):
    halfp = p//2
    if x>halfp:
        return x-p
    else:
        return x

