from datetime import datetime

def get_datetime():
    temp = str(datetime.now())[:19]
    split = temp.split(':')
    return split[0] + '-' + split[1] + '-' + split[2]

def output_dim(in_dims, stride, kernel_size):
    num_layers = len(stride)
    out_dims = [in_dims[0], in_dims[1], in_dims[2]]
    for i in range(num_layers):
        for j in range(3):
            out_dims[j] = int((out_dims[j] - kernel_size[i])/stride[i] + 1)
    return out_dims

def output_dim_conv3d(in_dims, stride, kernel_size, padding, pooling_kernels = None):
    num_layers = len(stride)
    out_dims = [in_dims[0], in_dims[1], in_dims[2]]
    for i in range(num_layers):
        for j in range(3):
            out_dims[j] = int((out_dims[j] + 2*padding[i] - kernel_size[i])/stride[i] + 1)
            if pooling_kernels is not None:
                if pooling_kernels[i] is not None:
                    # assume pooling with no stride, padding 0, dilation 1
                    out_dims[j] = int((out_dims[j] - pooling_kernels[i])/pooling_kernels[i] + 1)
                
    return out_dims

def saveTextfromList(data, savePATH):
    with open(savePATH, 'w') as f:
        for item in data:
            f.write("%f\n" % item)
    return True

def saveTextfromArray(data, savePATH):
    with open(savePATH, 'w') as f:
        for item in data:
            for item_i in item:
                f.write("%f " % item_i)
            f.write("\n")
    return True

def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False

def loadDatafromText(savedPATH):
    output = []
    f = open(savedPATH, 'r')
    for y in f.read().split('\n'):
        if is_number(y):
            output.append(float(y))
    return output

def loadArrayfromText(savedPATH):
    output = []
    f = open(savedPATH, 'r')
    for y in f.read().split('\n'):
        output_i = []
        for y_i in y.split(' '):
            if is_number(y_i):
                output_i.append(float(y_i))
        if len(output_i) > 0:
            output.append(output_i)
    return output