import logging
from datetime import date, datetime

def getDate(printHour = False):
    today = date.today()
    todaystr = str(today.year % 100) + str(today.month // 10) + str(today.month % 10) \
    + str(today.day // 10) + str(today.day % 10)
    if printHour:
        todaystr += datetime.now().strftime('-%H:%M')
    return todaystr

def set_logger(loggingFileName):
    # https://minimin2.tistory.com/41
    # 로그 생성
    logger = logging.getLogger()
    if (logger.hasHandlers()):
        logger.handlers.clear()
    
    # 로그의 출력 기준 설정
    logger.setLevel(logging.INFO)

    # log 출력 형식
    formatter = logging.Formatter('%(asctime)s - %(message)s')

    # log 출력
    stream_handler = logging.StreamHandler()
    stream_handler.setFormatter(formatter)
    logger.addHandler(stream_handler)

    # log를 파일에 출력
    file_handler = logging.FileHandler(loggingFileName + '.log')
    file_handler.setFormatter(formatter)
    logger.addHandler(file_handler)
    return logger

def print_info(string, logger = None):
    if logger is None:
        print(string)
    else:
        logger.info(string)
