# Dependencies
- numpy
- scipy
- imageio
- geomstats
- pytorch library (used version 1.7.0 with CUDA 11.0)
- torch_batch_svd library for the implementation of GDAE/GRCAE [torch_batch_svd](https://github.com/KinglittleQ/torch-batch-svd)
- nibabel library for saving DTI filtering results [nibabel](https://nipy.org/nibabel/)
- scikit-learn library for clustering performance evaluation [sklearn](https://scikit-learn.org/stable/)
- Other dependencies listed in https://github.com/seungyeon-k/SMF-public (or in README.md in `gae_pointcloud` folder) for point cloud data experiments. (They list a different version of pytorch library, but the above listed version also works well.)

# Note
All codes assume the usage of GPU.

# How to train the autoencoders for S^n:
See `train_DAE.ipynb` (for DAE and RCAE) and `train_GDAE.ipynb` (for GDAE and GRCAE) files in `gae_sph` folder.

See `sampling_example.ipynb` in `gae_sph` folder for the example of sampling on S^2 using GDAE and GRCAE **(Section 4.2)**.

See `clustering_example.ipynb` in `gae_sph` folder for the example of clustering of hyperspherical data using GDAE **(Section 4.3)**.

# How to train the autoencoders for P(n):
See `train_DAE.ipynb` (for DAE and RCAE) and `train_GDAE.ipynb` (for GDAE and GRCAE) files in `gae_pd` folder.

See `geometric_score_estimation_example.ipynb` in `gae_pd` folder for the example of geometric score estimation for P(n) data using GDAE **(Section 4.1)**.

# How to train the autoencoders for DTI or N(n):
See `train_DAE.ipynb` (for DAE) and `train_GDAE.ipynb` (for GDAE) files in `gae_DTI` folder **(Section 4.4)**.

# How to train the autoencoders for point cloud data:
The codes are modified from those in https://github.com/seungyeon-k/SMF-public. 

Please set `dataset/` directory in `gae_pointcloud` folder as explained in https://github.com/seungyeon-k/SMF-public. 

Especially set `modelnet10_hdf5_2048`, `modelnet40_hdf5_2048`, and `shapenetcorev2_hdf5_2048` folders (downloadable from [https://github.com/antao97/PointCloudDatasets](https://github.com/antao97/PointCloudDatasets)) for the experiments provided in Section 4.5 of the manuscript.

To train the autoencoders for point cloud data, please go to `gae_pointcloud` folder and run the following scripts **(Section 4.5)**:

For DAE/GDAE,
```
python train.py --config configs/fcnet_noise_{V}_config.yml --model.denoise_reg {R} --model.denoise_use_identity {B}
```
- `V` is either `1`, `5`, `10`, or `20`.
- `R` is set to `1e-1' for DAE, and `1e-4` for GDAE.
- `B` is `True` for DAE, and `False` for GDAE.

For AE + R./GDAE + R. (defined in Section 4.5 of the manuscript),
```
python train.py --config configs/fcnet_noise_{V}_config.yml --model.denoise_reg {R} --model.fm_reg {F}
```
- `V` is either `1`, `5`, `10`, or `20`.
- `R` is `None` for AE + R., and `1e-4` for GDAE + R.
- `F` is set to `8000`.
