# On the Evolution of Neuron Communities in a Deep Learning Architecture

This code explains ways of analyzing the neuron activation pattern proposed in PID_3321.


## Requirements
Python 3.7 or later\

see `requirement.txt` for exact authors environment.

## Calculating Modularity
At first, we need to train a model and save the activation values. The following code will train a model on MNIST dataset and save the activation values of layer 1 (Dense), layer 2 (Dense), and layer 3 (Output).

```
python Training_Model.py
python Train_Save_Activation.py
```

Next, we need to calculate adjacency matrix representing the graphs, created from the activation values, as follows

```
python Create_Adjacency_Matrix.py
```

Create_Adjacency_Matrix.py takes input the activation values and calcualtes the adjacency matrices of different layers. The results are stored as, 'Adjcency_Matrix/Layer_1'.

Finally we need to run 

```
python Modularity.py
```

Modularity.py takes the adjacency matrices and calcualtes the modularities using different modularity functions. The results are stored as, 'Results/Modularity/Layer_1'.

## Calculating Entropy

After storing the activation values using `python Train_Save_Activation.py`, we can use the following code to calculate the entropy of all the entire dataset for different epochs using the code as follows

```
python Entropy_All_Class.py
```

It will save the entropy values of each iteration in 'Results/Entropy/All_Class'.

If we want to calculate the entropy of individual classes we can use the code as follows

```
python Entropy_All_Class.py
```

It will save the entropy values for different classes and different iterations in 'Results/Entropy/Per_Class'

## Miscellaneous 

```
python Classification_Accuracy.py
```

Will store the classification accuracy of the dataset for iteration, as well as the classification accuracy of individual classes in 'Accuracy' folder.