import hydra
from omegaconf import OmegaConf


@hydra.main(config_path="conf", config_name="config.yaml")
def main(cfg):
    from ANONYMOUS.logging import get_logger

    OmegaConf.set_struct(cfg, False)
    get_logger("ANONYMOUS_ABC_.log", clear=True, level="DEBUG")

    import trainer

    if cfg.is_dist:
        trainer.dist_run(cfg)
    else:
        trainer.run(cfg)


if __name__ == "__main__":
    main()  # pylint: disable=no-value-for-parameter
