import torch as th

from modules import import_fns


def model_from_fckpt(fckpt: str):
    ckpt = th.load(fckpt)
    cfg = ckpt["cfg"]
    model_fn, _, _ = import_fns(cfg.model)
    model = model_fn(cfg.model)
    model.load_state_dict(ckpt["model"])
    return model
