Adversarial Transfer
===================

**Preparation**:
1. *Package dependencies*: Use `conda env create -f environment.yml` to create a conda env and
activate by `conda activate adv_transfer`. Major dependencies include
`pytorch, torchvision, wandb, numpy` for model size customization, and `advertorch`
for adversarial training.
2. *Data*: Set up your paths to data in [utils/config.py](utils/config.py). Refer to
[FedBN](https://github.com/med-air/FedBN#dataset--pretrained-modeel) for details of Digits datasets.
   * Cifar10: Auto download by `python -m utils.data_utils --download=Cifar10`.
   * Digits: Download the [FedBN Digits zip file](https://drive.google.com/file/d/1moBE_ASD5vIOaU8ZHm_Nsj0KAfX5T0Sf/view?usp=sharing) to `DATA_PATHS['Digits']'`
   defined in `utils.config`.  Unzip all files.

Run:
```shell
# Train on MNIST
python PDG_AT.py --train=adv --domain=MNIST
# Test on SVHN
python PDG_AT.py --train=adv --domain=MNIST --test --test_domain=SVHN
```

Check [sweeps](sweeps/) for details of hyper-parameters.
