# The Unreasonable Effectiveness of Fully-Connected Layers for Low-Data Regimes

This repository the official implementation of **The Unreasonable Effectiveness of Fully-Connected Layers for Low-Data Regimes**.
![OJKD](resources/illustration/online_joint_knowledge_distillation.png)

![FR](resources/illustration/feature_refiner.png)

## Requirements
### Installation
#### 1. Install Anaconda
To manage the packages easier, we use Anaconda. To install it on the cluster,
call the following command from your home directory:

```bash
wget https://repo.continuum.io/archive/Anaconda3-2020.02-Linux-x86_64.sh
bash ./Anaconda3-2020.02-Linux-x86_64.sh
```

#### 2. Create environment
```bash
conda create -n adl4cv python=3.7
```

#### 3. Install the requirements
During our experiments, we used CUDA 11.0. We recommend to use the same to ensure compatibility. Otherwise, please update the requirements file according to your specification. 
```bash
conda activate adl4cv
python -m pip install -r ./requirements.txt
```

### Dataset
Please download the datasets with the split definitions from [here](https://drive.google.com/drive/folders/1hDkqxn6PVBmQpjrtQZHZr962ZMbSbOL_?usp=sharing) and extract them to the `data` folder.



## Repository structure
### ADL4CV
This is our main module containing the implementation of our training loop, dataloading and the models.

### Cloud
This module contains helpful scripts for running the trainings in a SLURM cluster environment. 

### Data
Folder containing the downloaded datasets and data split definitions. 

### External
Module containing external repositories. 

### GUI
Our visualization tool for result analysis. We recommend to use our tool for best overview over the logs of our code. More information can be found in the module. 

### Logs
The logs of the training, together with the trained models. The logs of the experiments presented in the paper can be downloaded from [here](https://drive.google.com/drive/folders/1hDkqxn6PVBmQpjrtQZHZr962ZMbSbOL_?usp=sharing). These logs can be directly visualized with our GUI module. 





## Training and evaluation
Our training scripts train, and save the models under the logs folder. It also evaluates the final model on the respective test set. The logs can be easily visualized with our anylitics tool. For further details, please refer to the GUI module. 

### Supervised learning
#### Training commands
```
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc resnet -m ResNet18 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc fr -m FeatureRefiner -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc resnet -m ResNet18 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc fr -m FeatureRefiner -iidi -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc resnet -m ResNet18 -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc fr -m FeatureRefiner -iidi -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -fs 256 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc resnet -m ResNet18 -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_supervised -desc fr -m FeatureRefiner -iidi -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -fs 256 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
```
#### Results
![FR](resources/results/supervised/supervised.png)

### Model comparison
For the ViT trainings, please refer to the installation instructions of the respective module. 
```
sbatch --export=ALL,SCRIPT_ARGUMENTS="--lr 1e-4 --aug --n_epochs 500" cloud/cluster/slurm_submit_vit_all_stages.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="./data --dataset cifar10 -b 128 --img-size 224 --epochs 200 --color-jitter=0 --amp --sched cosine --model-ema --model-ema-decay 0.995 --reprob 0.5 --smoothing 0.1 --min-lr 1e-8 --warmup-epochs 3 --train-interpolation bilinear --aa v0 --lr 1e-2 --model mixer_s16_224 --opt sgd --weight-decay 5e-4" cloud/cluster/slurm_submit_timm_all_stages.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="--lr 1e-4 --aug --n_epochs 500 -d cifar100" cloud/cluster/slurm_submit_vit_all_stages.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="./data --dataset cifar100 -b 128 --img-size 224 --epochs 200 --color-jitter=0 --amp --sched cosine --model-ema --model-ema-decay 0.995 --reprob 0.5 --smoothing 0.1 --min-lr 1e-8 --warmup-epochs 3 --train-interpolation bilinear --aa v0 --lr 1e-2 --model mixer_s16_224 --opt sgd --weight-decay 5e-4" cloud/cluster/slurm_submit_timm_all_stages.sbatch
```
#### Results
![FR](resources/results/modelcomparison/modelcomparison.png)

### Active Learning
```
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_entropy -m ResNet18 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_coreset -m ResNet18 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt CoreSetQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc fr_resnet18_entropy -m FeatureRefiner -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet_llal -m ResNet18 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -tt LearningLossTrainer -qt ModelQuery" cloud/cluster/slurm_submit_benchmark.sbatch 

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_entropy -m ResNet18 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_coreset -m ResNet18 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt CoreSetQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc fr_resnet18_entropy -m FeatureRefiner -iidi -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet_llal -m ResNet18 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -tt LearningLossTrainer -qt ModelQuery" cloud/cluster/slurm_submit_benchmark.sbatch 

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_entropy -m ResNet18 -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_coreset -m ResNet18 -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt CoreSetQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc fr_resnet18 -m FeatureRefiner -iidi -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -fs 256 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet_llal -m ResNet18 -pt imagenet -d caltech101 -nts 6 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -tt LearningLossTrainer -qt ModelQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_entropy -m ResNet18 -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc resnet18_coreset -m ResNet18 -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -qt CoreSetQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al -desc fr_resnet18 -m FeatureRefiner -iidi -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -lrate 0.001 -me 100 -fs 256 -qt UncertaintyQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_al_nopt -desc resnet_llal -m ResNet18 -pt imagenet -d caltech256 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -tt LearningLossTrainer -qt ModelQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
```
#### Results
![FR](resources/results/al/al.png)

### Backbone
```
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_resnet34 -desc resnet34 -m ResNet34 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_resnet34 -desc fr_resnet34 -m FeatureRefiner -bbm ResNet34 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_efficientnet -desc efficientnet -m EfficientNetB3 -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_efficientnet -desc fr_efficientnet -m FeatureRefiner -bbm EfficientNetB3 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_densenet -desc densenet -m DenseNet -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_densenet -desc fr_densenet -m FeatureRefiner -bbm DenseNet -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_resnet34 -desc resnet34 -m ResNet34 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_resnet34 -desc fr_resnet34 -m FeatureRefiner -bbm ResNet34 -iidi -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch 
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_efficientnet -desc efficientnet -m EfficientNetB3 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_efficientnet -desc fr_efficientnet -m FeatureRefiner -bbm EfficientNetB3 -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_densenet -desc densenet -m DenseNet -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_backbone_densenet -desc fr_densenet -m FeatureRefiner -bbm DenseNet -iidi -d cifar100 -nts 10 -ot SGD -nis 5000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
```
#### Results
![FR](resources/results/backbone/backbone.png)

### Ablation
```
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_architecture -desc 1_onelayer_nodimred -m FeatureRefiner -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 512 -qt RandomQuery -tfc -dn1 True -dl1 True -dl2 True -dn2 True" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_architecture -desc 2_onelayer_dimred -m FeatureRefiner -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc -dn1 True -dl1 True -dl2 True -dn2 True" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_architecture -desc 3_fr_nolayernorm -m FeatureRefiner -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc -dn1 True -dn2 True" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_nogradgate -desc fr -m FeatureRefiner -gm 1.0 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch

sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_numlayer -desc fr_2layers -m FeatureRefiner -nil 2 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_numlayer -desc fr_3layers -m FeatureRefiner -nil 3 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_numlayer -desc fr_4layers -m FeatureRefiner -nil 4 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
sbatch --export=ALL,SCRIPT_ARGUMENTS="-rs neurips_ablation_numlayer -desc fr_5layers -m FeatureRefiner -nil 5 -iidi -d cifar10 -ot SGD -nis 1000 -bs 100 -lratemsr 0.8 -nsteps 10000 -fs 64 -qt RandomQuery -tfc" cloud/cluster/slurm_submit_benchmark.sbatch
```
#### Results
![FR](resources/results/ablation/ablation.png)
