import sys

from external.timm.pytorch_image_models.timm.data import IMAGENET_DEFAULT_MEAN, IMAGENET_DEFAULT_STD

sys.path.append('../../../')

import torch.nn as nn
from external.timm.pytorch_image_models.timm.models.registry import register_model

from external.timm.pytorch_image_models.timm.models.resnet import resnet18


_cfg = {
    'url': '',
    'num_classes': 1000, 'input_size': (3, 224, 224), 'pool_size': None,
    'crop_pct': .96, 'interpolation': 'bicubic',
    'mean': IMAGENET_DEFAULT_MEAN, 'std': IMAGENET_DEFAULT_STD, 'classifier': 'head'
}


@register_model
def feature_transformer(pretrained=False, **kwargs):
    model = FeatureTransformer(**kwargs)
    model.default_cfg = _cfg
    return model


class FeatureTransformer(nn.Module):
    def __init__(self, n_classes=10, **kwargs):
        super().__init__()
        resnet_feature_size = 512
        hidden_dim = 64
        self.num_classes = n_classes
        self.resnet = resnet18(pretrained=False, **kwargs)
        self.avg_pool = nn.AdaptiveAvgPool2d(output_size=(1, 1))
        self.flatten = nn.Flatten()

        self.hybrid_fc = nn.Linear(resnet_feature_size, hidden_dim)

        self.norm1 = nn.LayerNorm(hidden_dim)
        self.linear1 = nn.Linear(hidden_dim, hidden_dim)
        self.activation = nn.ReLU()
        self.linear2 = nn.Linear(hidden_dim, hidden_dim)
        self.norm2 = nn.LayerNorm(hidden_dim)

        self.head = nn.Linear(in_features=64, out_features=self.num_classes, bias=False)

    def forward(self, x):
        x = self.resnet.forward_features(x)
        x = self.avg_pool(x)
        x = self.flatten(x)

        # --------------------- Feature Transformer ---------------------
        x = self.hybrid_fc(x)

        x = self.norm1(x)
        x = self.linear1(x)
        x = self.activation(x)
        x = self.linear2(x)
        x = self.norm2(x)
        # ----------------------------------------------------------------
        x = self.head(x)
        return x
