#!/usr/bin/env python

import functools
import inspect
import sys
from abc import ABCMeta
from functools import partial, wraps
from inspect import Parameter, signature
from typing import Callable, Optional


def debug(func):
    @wraps(func)
    def wrapper(*func_args, **func_kwargs):
        print("\n" + "-" * 80 + "\n")
        print(f"Inside {func}")
        print(f"{signature(func)=}")
        print(f"{func_args=}")
        print(f"{func_kwargs=}")
        return func(*func_args, **func_kwargs)

    return wrapper


# class deco_meta(ABCMeta):
#     @debug
#     def __init__(cls, *args,  __init__=2, **kwargs):
#         super().__init__(*args, **kwargs)
#
#
# class deco(metaclass=deco_meta):
#     @debug
#     def __new__(cls, *args,  __new__=2, **kwargs):
#         return super().__new__(cls)
#
#     @debug
#     def __init__(self, *args, __init__=None, __func__=None, **kwargs):
#         pass
#
#     @debug
#     def __call__(self, *args,  __call__=None, **kwargs):
#         pass
#
# @deco
# @debug
# def dummy_function(*args, **kwargs):
#     return
#
# print(dummy_function(1))
# #
# print("="*80 + "\n" + "="*80)
#
# @deco(1,2,3, a=2, b=2, c=3)
# @debug
# def dummy_function(*args, **kwargs):
#     return
#
# print(dummy_function(1))


# sys.exit(0)


# def decoratorFunctionWithArguments(arg1, arg2, arg3):
#     def wrap(f):
#         print("Inside wrap()")
#         def wrapped_f(*args):
#             print("Inside wrapped_f()")
#             print("Decorator arguments:", arg1, arg2, arg3)
#             f(*args)
#             print("After f(*args)")
#         return wrapped_f
#     return wrap
#
# @decoratorFunctionWithArguments("hello", "world", 42)
# def sayHello(a1, a2, a3, a4):
#     print('sayHello arguments:', a1, a2, a3, a4)
#
# sayHello(1,2, 3, 4)


##############################################


@debug
def parametrized(decorator):
    @debug
    def generated_decorator(*args, **kwargs):
        @debug
        def wrapper(func):
            return decorator(func, *args, **kwargs)

        return wrapper

    return generated_decorator


@debug
def double(f):
    @debug
    def aux(*xs, **kws):
        return 2 * f(*xs, **kws)

    return aux


@double
@debug
def function(a):
    return 10 + a


@parametrized
def multiply(f, *args, **kwargs):
    print(f"{args=}")
    print(f"{kwargs=}")

    def aux(*xs, **kws):
        if len(args) > 0:
            return args[0] * f(*xs, **kws)
        return f(*xs, **kws)

    return aux


@multiply
def function(a):
    return 10 + a


print(function(3))  # Prints 26


@multiply(3)
def function_again(a):
    return 10 + a


print(function(3))  # Keeps printing 26
print(function_again(3))  # Prints 39, namely 3 * (10 + 3)
print(function(3))  # Prints 26, namely 2 * (10 + 3)


def decorator_factory(argument):
    def decorator(function):
        def wrapper(*args, **kwargs):
            # funny_stuff()
            # something_with_argument(argument)
            result = function(*args, **kwargs)
            # more_funny_stuff()
            return result

        return wrapper

    return decorator


def decorator_with_positionals(__fun__: Callable, a, b, /, c, d, *args, e, f, **kwargs):
    assert callable(__fun__) or __fun__ is None

    def _decorator(func):
        @functools.wraps(func)
        def wrapper(*func_args, **func_kwargs):
            print(
                f"""
                {a=} reporting in
                {b=} reporting in
                {c=} reporting in
                {d=} reporting in
                {e=} reporting in
                {f=} reporting in
                {args=} reporting in
                {kwargs=} reporting in
                """
            )
            return func(*func_args, **func_kwargs)

        return wrapper

    return _decorator(__fun__) if callable(__fun__) else _decorator


def decorator_without_positionals(__fun__: Callable, /, c, d, *, e, f):
    assert callable(__fun__) or __fun__ is None

    def _decorator(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            print(f"{x=} reporting in" for x in (c, d, e, f))
            return func(*args, **kwargs)

        return wrapper

    return _decorator(__fun__) if callable(__fun__) else _decorator


def parametrized_decorator(decorator, *meta_args, **meta_kwargs):
    r"""The decorator must have the signature (func, pos_only, kw).

    I.e. the function must be the first argument!
    """
    print(f"{meta_args=}")
    print(f"{meta_kwargs=}")
    # sig = signature(decorator)
    # parameters = sig.parameters.values()
    # num_pos_only_args = len([param for param in parameters if param.kind == Parameter.POSITIONAL_ONLY])
    # if num_pos_only_args == 0:
    #     pass

    def _autogenerated_decorator(*decorator_args, **decorator_kwargs):
        print(f"Entering {decorator=}")
        print(f"{decorator_args=}")
        print(f"{decorator_kwargs=}")
        print(f"constructing wrapper")

        def wrapper(decorator, *wrapper_args, **wrapper_kwargs):
            print(f"Entering {wrapper=}")
            print(f"{wrapper_args=}")
            print(f"{wrapper_kwargs=}")
            result = decorator(*decorator_args, **decorator_kwargs)
            print(f"Exiting  {decorator=}")

            if len(decorator_args) == 0 and len(decorator_kwargs) == 0:
                pass

            return result

        print("Finished constructing wrapper")

        return wrapper

    return _autogenerated_decorator


@parametrized_decorator
def add(function: Callable[[float], float], bias: float = 0.0):
    @wraps(function)
    def wrapper(*function_args, **function_kwargs):
        print(f"Entering {function=}")
        print(f"{function_args=}")
        print(f"{function_kwargs=}")
        result = function(*function_args, **function_kwargs) + bias
        print(f"Exiting  {function=}")
        return result

    return wrapper


@add(bias=3)
def identity(x):
    return x


print(identity(3))

# @add(bias=2)
# def identity(x):
#     return x
# print(identity(3))


#
def multiplying(f_py=None, factor=1):
    assert callable(f_py) or f_py is None

    def _decorator(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            return factor * func(*args, **kwargs)

        return wrapper

    return _decorator(f_py) if callable(f_py) else _decorator


#
#
# @multiplying
# def summing(x): return sum(x)
#
# print(summing(range(10)))
# # 45
#
#
# @multiplying()
# def summing(x): return sum(x)
#
# print(summing(range(10)))
# # 45
#
#
# @multiplying(10)
# def summing(x): return sum(x)
#
# print(summing(range(10)))
# 450
