[GitLab recommends](https://docs.gitlab.com/ee/user/project/repository/reducing_the_repo_size_using_git.html) [`git filter-repo`](https://github.com/newren/git-filter-repo/blob/main/README.md) over [`git filter-branch`](https://git-scm.com/docs/git-filter-branch) and [`BFG`](https://rtyley.github.io/bfg-repo-cleaner/).

Some usage examples are given in https://github.com/newren/git-filter-repo/tree/main/contrib/filter-repo-demos:

| Command&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; | Description                                                                                                                                                                                                                                       |
| ------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| barebones-example                                                                                                                                       | Simple example with no modifications to filter-repo behavior, just showing what to import and run.                                                                                                                                                |
| insert-beginning                                                                                                                                        | Add a new file (e.g. LICENSE/COPYING) to the beginning of history.                                                                                                                                                                                |
| signed-off-by                                                                                                                                           | Add a Signed-off-by tag to a range of commits                                                                                                                                                                                                     |
| lint-history                                                                                                                                            | Run some lint command on all non-binary files in history.                                                                                                                                                                                         |
| clean-ignore                                                                                                                                            | Delete files from history which match current gitignore rules.                                                                                                                                                                                    |
| filter-lamely (or filter&#8209;branch&#8209;ish)                                                                                                        | A nearly bug compatible re-implementation of filter-branch (the git testsuite passes using it instead of filter-branch), with some performance tricks to make it several times faster (though it's still glacially slow compared to filter-repo). |
