# Projective Splitting for Distributionally-Robust Sparse Logistic Regression

This repository includes code to replicate the results in the paper:
*Stochastic Projective Splitting: Solving Saddle-Point Problems with Multiple Regularizers*. 



##Install

This code is tested with `python 3.8.3` and `numpy 1.18.5`.
 You also need `scipy` and `scikitlearn`.

## Datasets

You need to download the three datasets from 
[libsvm](https://www.csie.ntu.edu.tw/~cjlin/libsvmtools/datasets/binary.html).
The datasets are:
* *epsilon*
* *SUSY*
* *real-sim*

Each dataset is in `.bz` format. On Unix systems, you can unpack each dataset with
```
bzip2 -d -k data_file.bz2
``` 

Store all three datasets in the same folder. The *dataloc* variable, 
defined on line 22 of *main.py* must be set to the full or relative path to this
folder. 

## How to Run

First do the following,

* download the three datasets from
[libsvm](https://www.csie.ntu.edu.tw/~cjlin/libsvmtools/datasets/binary.html)
* unpack the datasets as discussed above
* Set the *dataloc* variable, defined on line 22 of *main.py*, to the full (or relative) path to the folder 
containing the three datasets
* In *main.py*, select which of the three datasets to run by uncommenting the appropriate line from lines 
17, 18, and 19


 Then simply run with 
```
python main.py
```

to rerun the experiment and regenerate the plot from the paper.

## Files

* *main.py* runs the experiments and plots results
* *problem.py* defines the DRSLR problem in terms of the `DR_s_LR` class
* *projSplitting.py* defines the proposed PS method
* *Tseng.py* defines Tseng's method
* *FRB.py* defines the forward reflected backward (FRB) method.
