# MLRC Reproducibility Challenge

This is a reproducibility study for the paper *Improving Interpretation Faithfulness for Vision Transformers* published at ICML 2024 Spotlight. 

## Environment Setup
Please set up the environment following `env.yaml` by using conda. After that, please clone https://github.com/openai/guided-diffusion and put it in the same directory as this repo. 


## Setup

### Installing

Setup conda environment using ```env.yaml``` file.


### Downloads

#### Weights

Please download trained diffusion model weights [256x256_diffusion_uncond.pt](https://openaipublic.blob.core.windows.net/diffusion/jul-2021/256x256_diffusion_uncond.pt) and put it in the `guided_diffusion/models/` directory.

Please download the autoencoder from https://ommer-lab.com/files/latent-diffusion/vq-f8.zip and put it in ckpts/vq-f8 folder

Please download the latent diffusion model from https://ommer-lab.com/files/latent-diffusion/cin.zip and put it in ckpts/cin folder

#### Segmentation
Download the [script to obtain segmentation images](http://calvin-vision.net/bigstuff/proj-imagenet/data/gtsegs_ijcv.mat) and place it in your data directory(eg `data_dir/`).

#### Classification and Perturbation Tests
Download ImageNet 2012 [devkit](https://image-net.org/data/ILSVRC/2012/ILSVRC2012_devkit_t12.tar.gz) and [val](https://image-net.org/data/ILSVRC/2012/ILSVRC2012_img_val.tar) dataset and place the files in your data directory (eg `data_dir/`).

#### Extension

Download the blur.tar and digital.tar of Imagenet-C dataset from https://zenodo.org/records/2235448 and place the files in your data directory (eg `data_dir/`).


## Running experiments
### Section A. Segmentation Results

```bash
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=./:$PYTHONPATH python3 src/segmentation.py --method transformer_attribution --dds True --attack True --imagenet-seg-path /path/to/gtsegs_ijcv.mat
```

In the example above we run a segmentation test with our method. Notice you can choose which method you wish to run using the `--method` argument. You must provide a path to imagenet segmentation data in `--imagenet-seg-path`.


### Section B. Classification
```
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=./:$PYTHONPATH python3 src/classification.py --model vit --attack True
```
 
### Section C. Perturbation Results

You need to run `src/generate_visualization.py` to create results.hdf5 before running `src/perturbations.py` script.


```bash
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=./:$PYTHONPATH python3 src/generate_visualizations.py --method dds --imagenet-validation-path /path/to/imagenet_validation_directory --to-attack --noise-level 4
```
Notice that you can choose to visualize by target or top class by using the `--vis-cls argument`. You can choose to attack by passing the `--to-attack` argument and specify the attack radius using the `--noise-level`.


```bash
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=./:$PYTHONPATH python3 src/perturbations.py --method dds --attacked
```
Notice that you can use the `--neg` argument to run negative perturbation and the `--attacked` argument to perform it for attacked visualizations.


## Playing with examples
We provide some examples in `fig` folder. You can run the corresponding experiments to see different explanation results in the `fvit-demo.ipynb` notebook.

### Ours

![image-20230126150942852](https://s2.loli.net/2023/01/27/Z8fzDcptxs4LUB3.png)

### VTA

![image-20230126151007281](https://s2.loli.net/2023/01/27/gCKXEsMIrPbFS86.png)


## Extensions
All experiments and results for our extensions are available in the `extensions` branch

## References

Our code implementation is based on the following awesome material:

1. https://github.com/jacobgil/vit-explain
2. https://jacobgil.github.io/deeplearning/vision-transformer-explainability
3. https://arxiv.org/abs/2005.00928
4. https://github.com/hila-chefer/Transformer-Explainability
5. https://github.com/openai/guided-diffusion


## Citation

All rights belong to the authors. Suggest cite:

```
@inproceedings{huimproving,
title={Improving Interpretation Faithfulness for Vision Transformers},
author={Hu, Lijie and Liu, Yixin and Liu, Ninghao and Huai, Mengdi and Sun, Lichao and Wang, Di},
booktitle={Forty-first International Conference on Machine Learning}
}
```
