import numpy as np
import torch


def drop_lowest_max_fuse(arr, ratio=10):
    arr_out = arr[0]
    arr_out[arr_out < np.percentile(arr_out, ratio)]=0
    for i in range(1,len(arr)):
        arr_new = arr[i]
        arr_new[arr_new < np.percentile(arr_new, ratio)]=0
        arr_out = np.maximum(arr_out,arr_new)
    return arr_out

def max_fuse(arr):
    arr_out = arr[0]
    for i in range(1,len(arr)):
        arr_out = np.maximum(arr_out,arr[i])
    return arr_out

def mean_fuse(arr):
    arr_out = arr[0]
    for i in range(1,len(arr)):
        arr_out = arr_out + arr[i]
    return arr_out/len(arr)

def min_max_normal(arr):
    return (arr - arr.min())/(arr.max() - arr.min())


def normalize(tensor,
              mean=[0.5, 0.5, 0.5], std=[0.5, 0.5, 0.5]):
    dtype = tensor.dtype
    mean = torch.as_tensor(mean, dtype=dtype, device=tensor.device)
    std = torch.as_tensor(std, dtype=dtype, device=tensor.device)
    tensor.sub_(mean[None, :, None, None]).div_(std[None, :, None, None])
    return tensor