#!/bin/bash

# Default values
START=0
END=0

# Parse command-line arguments
while [[ "$#" -gt 0 ]]; do
    case $1 in
        --start) START="$2"; shift ;;
        --end) END="$2"; shift ;;
        *) echo "Unknown parameter passed: $1"; exit 1 ;;
    esac
    shift
done

python3 src/sweep_base.py \
    --output-dir "$GCS_MODEL_DIR" \
    --train-dataset-shards "$GCS_DATASET_DIR/imagenet-1k-wds/imagenet1k-train-{0000..1023}.tar" \
    --valid-dataset-shards "$GCS_DATASET_DIR/imagenet-1k-wds/imagenet1k-validation-{00..63}.tar" \
    --name "$(basename "$0" .sh)" \
    --ipaddr "$(curl -s ifconfig.me)" \
    --hostname "$(hostname)" \
    --start "$START" \
    --end "$END"