
clear
clc
wd = 'EMGVB';
addpath(genpath('VBLab'))
addpath('Har_model')
addpath('Figures')

%%

load('Make_data\Data\HARdata.mat')
Data = mk_train_test_data(HAR.SPX{:,:},0.8);

lm.fit  = fitlm(Data.train(:,2:end),Data.train(:,1),'linear','Intercept',false);
lm.beta = lm.fit.Coefficients.Estimate;
lm.tpar  = [lm.beta;log(lm.fit.RMSE)];
lm.par   = [lm.beta;lm.fit.RMSE];
[~,~,~,~,lm.train_ll,lm.train_mse]  = get_XYmu(Data.train,lm.tpar);
[~,~,~,~,lm.test_ll,lm.test_mse]    = get_XYmu(Data.test,lm.tpar);

lm.perf = [nan,lm.train_ll,lm.train_mse, nan,lm.test_ll,lm.test_mse];

seed = 2022;

setting.Prior.Mu        = 0;
setting.Prior.Sig       = 5;


%%

opt.lr              = 0.001;
opt.maxiter         = 1200;
opt.maxPatience     = 500;
opt.stepAdaptive    = 1000;
opt.maxGrad         = 50000;
opt.nSample         = 100;
opt.clipInit        = 500;
opt.SigInitScale    = 0.01;
opt.MeanInit        = lm.tpar;

setting.isDiag = 0;
setting.useHfunc = 0;
setting.SigFactor = 2;

rng(seed)
pMGVB = MGVB_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);

%%

pMGVB.Post.mu
plot(pMGVB.Post.LB_smooth,'--')

%%
rng(seed)
pEMGVB = EMGVB_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);

rng(seed)
pQBVI = QBVI_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);

setting.isDiag = 1;

rng(seed)
pMGVB_d = MGVB_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);



rng(seed)
pEMGVB_d = EMGVB_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);


rng(seed)
pQBVI_d = QBVI_har(@h_func_m,Data,...
    'NumParams',5,...
    'MeanInit',opt.MeanInit,...
    'Setting',setting,...
    'LearningRate',opt.lr,...
    'NumSample',opt.nSample,...
    'MaxPatience',opt.maxPatience,...
    'MaxIter',opt.maxiter,...
    'GradWeight',0.4,...
    'WindowSize',30,...
    'SigInitScale',opt.SigInitScale,...
    'StepAdaptive',opt.stepAdaptive,...
    'GradientMax',opt.maxGrad,...
    'GradClipInit',opt.clipInit,...
    'SaveParams',true,...
    'Verbose',2,...
    'LBPlot',false);
%%

plot(pEMGVB.Post.LB_smooth)
hold on
plot(pMGVB.Post.LB_smooth,'--')
plot(pQBVI.Post.LB_smooth,':r')
hold off
xlim([1 1200])
%%


rng(seed)
Mdl = LinearRegression(5,...
    'Prior',{'Normal',[setting.Prior.Mu setting.Prior.Sig]},...
    'Intercept',false...
    );

mcmc.n = 100000;
pMCMC = MCMC(Mdl,Data.train,...    
    'NumMCMC',mcmc.n,...        
    'SigScale',1,...
    'ParamsInit',lm.tpar,...
    'Verbose',5000); 

%%

[mcmc.mean,mcmc.std,mcmc.params] = getParamsMean(pMCMC);
mcmc.tpar   = mcmc.mean';
mcmc.std    = mcmc.std';
mcmc.chain  = pMCMC.Post.theta(pMCMC.BurnIn+1:end,:);
mcmc.par    = [mcmc.tpar(1:end-1);exp(mcmc.tpar(end))];

[~,~,~,~,mcmc.train_ll,mcmc.train_mse] = get_XYmu(Data.train,mcmc.tpar);
[~,~,~,~,mcmc.test_ll,mcmc.test_mse] = get_XYmu(Data.test,mcmc.tpar);
mcmc.perf = [nan,mcmc.train_ll,mcmc.train_mse, nan,mcmc.test_ll,mcmc.test_mse];

%% Table

h = @(x) x.Post.perf;
f = @(x) x.Post.par;

tab_perf    = [h(pEMGVB);h(pMGVB);h(pQBVI);h(pEMGVB_d);h(pMGVB_d);h(pQBVI_d);mcmc.perf;lm.perf];
tab_est     = [f(pEMGVB);f(pMGVB);f(pQBVI);f(pEMGVB_d);f(pMGVB_d);f(pQBVI_d);mcmc.par';lm.par'];


%%

writematrix(tab_perf,'Har_model\Har_tables.xls','Sheet','perf')
writematrix(tab_est,'Har_model\Har_tables.xls','Sheet','est')


%%
clc
close
lw = 1.4;

subplot(1,2,1)
yyaxis left
plot(pEMGVB.Post.train.llh,'LineWidth',lw)
grid
ylabel('E$_q[p(y\vert\theta)]$','Interpreter','Latex')

yyaxis right
plot(pEMGVB.Post.train.mse,'LineWidth',lw)
xlabel('Iteration','Interpreter','Latex')
ylabel('MSE','Interpreter','Latex')
xlim([0 opt.maxiter])


subplot(1,2,2)
yyaxis left
plot(pEMGVB.Post.test.llh,'LineWidth',lw)
grid
ylabel('E$_q[p(y\vert\theta)]$','Interpreter','Latex')

yyaxis right
plot(pEMGVB.Post.test.mse,'LineWidth',lw)
xlabel('Iteration','Interpreter','Latex')
ylabel('MSE','Interpreter','Latex')
xlim([0 opt.maxiter])


set_fig(1600,400,600,180)
% savePDF('Figures\Har\','Har_MSE_Iter')


%%

close

lw = 1.4;
subplot(1,2,1)
plot(pEMGVB.Post.LB_smooth,'LineWidth',lw)
hold on
plot(pMGVB.Post.LB_smooth,'--','LineWidth',lw)
plot(pQBVI.Post.LB_smooth,':r','LineWidth',lw)
hold off
grid
xlabel('Iteration','Interpreter','Latex')
ylabel('Lower bound','Interpreter','Latex')
xlim([0 opt.maxiter])
legend({'EMGVB','MGVB','QBVI'},'Location','southeast')


subplot(1,2,2)
plot(pEMGVB_d.Post.LB_smooth,'LineWidth',lw)
hold on
plot(pMGVB_d.Post.LB_smooth,'--','LineWidth',lw)
plot(pQBVI_d.Post.LB_smooth,':r','LineWidth',lw)
hold off
grid
xlabel('Iteration','Interpreter','Latex')
ylabel('Lower bound','Interpreter','Latex')
xlim([0 opt.maxiter])
legend({'EMGVB diag.','MGVB diag.','QBVI diag.'},'Location','southeast')

set_fig(1600,400,600,180)
% savePDF('Figures\Har\','Har_ELBO')


%%


