

function[C,Lab] = Import_oxfordRM(filename)

fileID = fopen(filename);
h = fgets(fileID);
CC = textscan(fileID,'%10{yyyy-MM-dd}D %*s %*1s %s %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f',...
    'Delimiter',',','HeaderLines',1);
fclose(fileID);

h = strsplit(strtrim(string(h)),',');
h(1) = "Time";

Lab.raw = ["Time","Symbol","rsv","rk_parzen","rsv_ss","bv_ss","medrv","open_price","bv","rv5_ss","rv5","open_to_close","rv10_ss","rv10","nobs","close_price","rk_th2","rk_twoscale","open_time","close_time"]';
Lab.new = string({'Time','Stock','RSV','RKp','RSVss','BVss','MedRV','P_open','BV','RV5ss','RV5','Roc','RV10ss','RV10','Nobs','P_close','RKth','RKts','T_open','T_close'})';    
Lab.sorted = string({'Time','Stock','T_open','T_close','Dur','Nobs','P_open','P_close','Roc','Roo','Rcc','lRcc','RV5','RV10','RSV','BV','MedRV','RKp','RKth','RKts','RV5ss','RV10ss','RSVss','BVss'})';

[~,idx] = ismember(Lab.raw,h);
Lab.order = idx;
C = CC(Lab.order);

end
