clearvars -except wd
clc

wd = 'EMGVB\Make_data';
cd(wd); addpath(genpath(wd));

% url = 'https://realized.oxford-man.ox.ac.uk/images/oxfordmanrealizedvolatilityindices.zip';
% unzip(url,'Data') %This takes some time!!

filename = 'Data/oxfordmanrealizedvolatilityindices.csv';
[C,Lab] = Import_oxfordRM(filename);

%%
date_from   = datetime('2014-Jan-01');
date_to     = datetime(date);

Stock_list = ["SPX"];
RM = struct();

for i = 1:numel(Stock_list)

    Stock = Stock_list(i);

    s_indx = ismember(C{2},Stock);
    t_indx = C{1} >= date_from & C{1} <= date_to;

    Z = cellfun(@(c) c(s_indx & t_indx),C,'uni',0);
    f_dur = @(s) [s(end-numel(s)+1:end-4) ':' s(end-3:end-2) ':' s(end-1:end)];
    dur_open = duration(arrayfun(@(s) f_dur(num2str(s)),Z{19},'uni',0));
    dur_close = duration(arrayfun(@(s) f_dur(num2str(s)),Z{20},'uni',0));

    tab = table(Z{1:end});
    tab.Properties.VariableNames = Lab.raw;
    tab.open_time = dur_open;
    tab.close_time = dur_close;
    tab.Properties.VariableNames = Lab.new;
    tab.Roo     = [diff(tab.P_open)./tab.P_open(1:end-1);NaN]; %exact return
    tab.Rcc     = [NaN;diff(tab.P_close)./tab.P_close(1:end-1)]; %exact return
    tab.lRcc    = [NaN;log(tab.P_close(2:end)./tab.P_close(1:end-1))]; %log-return
    tab.Dur     = dur_close-dur_open;

    tab = tab(:,Lab.sorted);
    tab.Stock = string(tab.Stock);

    indx = tab.RV5 == 0 & tab.RV10 == 0 & tab.BV == 0 & tab.Roc == 0;
    tab(indx,:) = [];
    TT = table2timetable(tab);
    TT.Time.Format = 'yyyy-MMM-dd';
    RM.(Stock) =  TT;

    vol_to_use = RM.(Stock){:,{'RV5ss'}};
    HAR.(Stock) = mk_har_tab(sqrt(vol_to_use*252)*100,TT.Time); %std deviations * 100

    ret_demean    = 100*(TT.lRcc-mean(TT.lRcc,'omitnan'));
    GARCH.(Stock) = timetable(TT.Time,ret_demean,'VariableNames',{'t'});
    GARCH.(Stock) = GARCH.(Stock)(2:end,:);
    GARCH.(Stock).Properties.VariableNames = {'r'};

end

subplot(2,1,1)
plot(HAR.(Stock).Time,HAR.(Stock).t)
subplot(2,1,2)
plot(GARCH.(Stock).Time,GARCH.(Stock).r)


save(fullfile('Data','HARdata.mat'),'HAR')
save(fullfile('Data','GARCHdata.mat'),'GARCH')

%%




