function[mcmc] = do_mcmc(Data,pMCMC)

p = pMCMC.Model.P;
o = pMCMC.Model.O;
q = pMCMC.Model.Q;
GarchType = pMCMC.Model.GarchType;


Params      = getParamsMean(pMCMC);
mcmc        = Params;
mcmc.Params = Params;
mcmc.n      = pMCMC.NumMCMC;
mcmc.tpar   = mcmc.mu;
mcmc.par    = pMCMC.Model.itransform(mcmc.tpar);
mcmc.cov    = cov(mcmc.chain);
mcmc.Sig2   = diag(mcmc.cov);

[mcmc.train.nll,mcmc.train.ht]  = vol_nll(Data.train,mcmc.tpar,p,o,q,GarchType);
[mcmc.test.nll,mcmc.test.ht]    = vol_nll(Data.test,mcmc.tpar,p,o,q,GarchType);

mcmc.train.LB                 = nan;
mcmc.test.LB                  = nan;
mcmc.train.mse                = mean((Data.train.^2-mcmc.train.ht).^2);
mcmc.test.mse                 = mean((Data.test.^2-mcmc.test.ht).^2);
mcmc.perf = [mcmc.train.LB,mcmc.train.nll,mcmc.train.mse, mcmc.test.LB,mcmc.test.nll,mcmc.test.mse];


end