wd = 'EMGVB';
cd(wd)
addpath(genpath('Vol'))
addpath(genpath('VBLab'))

seed = 2022;

load('Vol\Data\GARCH.mat')
Data = mk_train_test_data_vol(GARCH.SPX.r,0.8);

setting.Prior = [0,5];

clc

p = 0;
o = 0;
q = 1;

poq = [num2str(p) num2str(o) num2str(q)];

GarchType = 'figarch';
GarchName = ['figarch' '_' poq];

ml = ml_vol(Data,p,o,q,GarchType);


%%

Run = 1;

if Run == 1
    Mdl = mcmc_garch_mdl('GarchType',GarchType,'P',p,'O',o,'Q',q,...
        'ParamsInit',ml.tpar','Prior',{'Normal',setting.Prior});
    pMCMC = MCMC_garch(Mdl,Data.train,'NumMCMC',100000,'SigScale',1,'Verbose',5000);

    mcmc = do_mcmc(Data,pMCMC);
    pMCMC.Params = mcmc.Params;
end

%%

opt = set_opt(GarchType,ml.tpar)
opt.Verbose = 1;


clc

rng(seed)
pMGVB = Vol_class(Data,...
    'Setting',setting,...
    'P',p,...
    'O',o,...
    'Q',q,...
    'MeanInit',opt.MeanInit,...
    'GarchType',GarchType,...
    'LearningRate',opt.lr,...     
    'NumSample',opt.nSample,...         
    'MaxPatience',opt.maxPatience ,...     
    'MaxIter',opt.maxiter,...                   
    'SigInitScale',opt.SigInitScale,...     
    'StepAdaptive',opt.stepAdaptive,...     
    'GradientMax',opt.maxGrad,...      
    'GradClipInit',opt.clipInit,...                
    'TrainTest',opt.TrainTest,...
    'Verbose',opt.Verbose,...
    'SaveParams',opt.SaveParams,...
    'useHfunc',opt.useHfunc,...
    'Optimizer','MGVB');

pEMGVB = Vol_class(Data,...
    'Setting',setting,...
    'P',p,...
    'O',o,...
    'Q',q,...
    'MeanInit',opt.MeanInit,...
    'GarchType',GarchType,...
    'LearningRate',opt.lr,...     
    'NumSample',opt.nSample,...         
    'MaxPatience',opt.maxPatience ,...     
    'MaxIter',opt.maxiter,...                   
    'SigInitScale',opt.SigInitScale,...     
    'StepAdaptive',opt.stepAdaptive,...     
    'GradientMax',opt.maxGrad,...      
    'GradClipInit',opt.clipInit,...                
    'TrainTest',opt.TrainTest,...
    'Verbose',opt.Verbose,...
    'SaveParams',opt.SaveParams,...
    'useHfunc',opt.useHfunc,...
    'Optimizer','EMGVB');

pQBVI = Vol_class(Data,...
    'Setting',setting,...
    'P',p,...
    'O',o,...
    'Q',q,...
    'MeanInit',opt.MeanInit,...
    'GarchType',GarchType,...
    'LearningRate',opt.lr,...     
    'NumSample',opt.nSample,...         
    'MaxPatience',opt.maxPatience ,...     
    'MaxIter',opt.maxiter,...                   
    'SigInitScale',opt.SigInitScale,...     
    'StepAdaptive',opt.stepAdaptive,...     
    'GradientMax',opt.maxGrad,...      
    'GradClipInit',opt.clipInit,...                
    'TrainTest',opt.TrainTest,...
    'Verbose',opt.Verbose,...
    'SaveParams',opt.SaveParams,...
    'useHfunc',opt.useHfunc,...
    'Optimizer','QBVI');


%% Plot LB

plot(pEMGVB.Post.LB_smooth)
hold on
plot(pMGVB.Post.LB_smooth,'--')
plot(pQBVI.Post.LB_smooth,':')
hold off

%%

clear Pl

k = 8;    
Pl.mgvb{1}    = get_xy_distribution(pMGVB,100,k,1);
Pl.emgvb{1}   = get_xy_distribution(pEMGVB,100,k,1);
Pl.qbvi{1}    = get_xy_distribution(pQBVI,100,k,1);
Pl.mc{1}      = get_xy_distribution(pMCMC,100,k,1);

Pl.mgvb{2}     = get_xy_distribution(pMGVB,100,k,0);
Pl.emgvb{2}    = get_xy_distribution(pEMGVB,100,k,0);
Pl.qbvi{2}     = get_xy_distribution(pQBVI,100,k,0);
Pl.mc{2}       = get_xy_distribution(pMCMC,100,k,0);

%%

file_name_mat = ['Vol\Results\' GarchName '.mat'];

save(file_name_mat,'opt','pEMGVB','pMGVB','pQBVI','Mdl','pMCMC',...
    'Data','ml','mcmc','Pl','GarchName','GarchType','setting','p','o','q')

%%

lbl = mk_lbl(GarchType,p,o,q);


f = @(x) x.Post.par';
h = @(x) x.Post.tpar';
g = @(x) x.Post.perf;

tab_par     = [f(pMGVB);f(pEMGVB);f(pQBVI);ml.par';mcmc.par'];
tab_tpar    = [h(pMGVB);h(pEMGVB);h(pQBVI);ml.tpar';mcmc.tpar'];
tab_perf    = [g(pMGVB);g(pEMGVB);g(pQBVI);ml.perf;mcmc.perf];
tab         = [tab_par,tab_perf];

tab = array2table(tab,'VariableNames',lbl);

file_name_xls = ['Vol\Results\' GarchName '.xls'];

writematrix(tab_perf,file_name_xls,'Sheet','perf')
writematrix(tab_par,file_name_xls,'Sheet','par')
writematrix(tab_tpar,file_name_xls,'Sheet','tpar')
writetable(tab,file_name_xls,'Sheet','main')

writetable(tab,'Vol\results\All_models.xls','Sheet',GarchName)

%% Plot MCMC

lw = 1.6;
fs = 12;

trans = 0;

nPar = pMGVB.NumParams;

for i = 1:nPar
    subplot(1,nPar,i)

    col = trans+1;

    plot(Pl.emgvb{col}.x(:,i),Pl.emgvb{col}.y(:,i))   
    mu_ml = ml.tab_ml{i,col};

    hold on
    plot(Pl.mc{col}.x(:,i),Pl.mc{col}.y(:,i),':k')
    plot(Pl.mgvb{col}.x(:,i),Pl.mgvb{col}.y(:,i),'--')
    plot(Pl.qbvi{col}.x(:,i),Pl.qbvi{col}.y(:,i),':r')
    xline(mu_ml,'--r','LineWidth',lw)
    hold off
   
end

title(GarchName,'Interpreter','none')


