# Error Estimation and Correction of Neural Network Differential Equation Solvers
----

### Examples

- An example command-line command to solve the Henon-Heiles system would be:  
```
python scripts/train_error_correct.py orders=1 data=HenonHeiles epochs=50000 optimizer.params.lr=8e-3 optimizer.name='Adam' optimizer.params.betas=[0.999,0.9999] batch_size=200 model.depth=2 model.dim.hidden=50 model.activation=sinusoid model.prefix=EXAMPLE-HH model.error_frequency=3 skip=5000 'injection_points={0:[0.5]}' random_seed=5 compute_error_magnitude=True data.max_step=1e-3 data.gt_solver="RK45" 
```

- Similarly for the Nonlinear Oscillator:  
```
python scripts/train_error_correct.py orders=1 data=nloscillator epochs=50000 optimizer.params.lr=8e-3 optimizer.name='Adam' optimizer.params.betas=[0.999,0.9999] batch_size=200 model.depth=2 model.dim.hidden=50 model.activation=sinusoid model.prefix=EXAMPLE-NLO model.error_frequency=3 skip=500 'injection_points={0:[0.5]}' random_seed=5 compute_error_magnitude=True data.max_step=1e-3 correct_best=True data.gt_solver="RK45"
```

- For nPBE:
```
python scripts/train_error_correct.py orders=1 data=nPBE epochs=400000 optimizer.params.lr=1e-3 optimizer.name='Adam' batch_size=1024 model.depth=4 model.dim.hidden=50 model.activation=sinusoid model.prefix=EXAMPLE-NPBE skip=4000 'injection_points={0:[0.5]}' random_seed=9999 correct_best=True data.omega=5 data.dims=2 data.n_test_points=1024 data.resolution=500 compute_error_magnitude=False
```

### Notice

- When specifying `compute_error_magnitude=True`, no information is retained or reflected in the saved file names for the corresponding run about the value of computed error magnitude. It is recommended to append extra information in the `model.prefix` parameter or save the logs to retain this information.

- When specifying `save_best=True`, no information is retained or reflected in the saved file names for the corresponding run about when (which epoch) the best model occured. It is recommended to append extra information in the `model.prefix` parameter or save the logs to retain this information.

- When specifying `compute_best=True`, the checkpoints are expected as usual (e.g. [0.5, 0.75, ...] of the total training epochs) however the best model UP UNTIL that checkpoint will be saved as the checkpoint model. A limitation of this feature is that it will NOT be reflected in the corresponding filenames for the metrics, models, or figures - i.e. the model encoding will still read `checkpoint-{p*total_epochs}-<PREFIX>-....pt`. This is due to the code structure and how the model tree is built and saved in `train_error_correct.py`. It is recommended to instead append extra information in the `model.prefix` parameter and save the logs for the corresponding runs in order to retain the best epoch information.
