"""Script for general miscellaneous utilities
"""
import logging

from math import ceil, log10

logger = logging.getLogger(__name__)


def next_highest_OM(number):
    """
    Computes the number 1e{a} where a is the next 
    highest order of magnitude of the input number
    """
    return 10**ceil(log10(number))


def model_encoding_str(hparams):
    """Encodes model name using the following scheme:
    
    TODO: update this documentation

    '{e}epochs_{l}x{i}x{h}x{o}'
    where:
        e - number of epochs
        l - number of hidden layers
        i, h, o - number of input, hidden, output units

    Args:
        hparams (DictConfig): hyperparams
    """
    prefix = hparams.model.prefix
    
    # for consistiency in the filename structure/encoding
    assert '_' not in prefix.split('/')[-1], (
        f"prefix '{prefix.split('/')[-1]}' must not contain '_', use '-' instead"
    )

    # encode model name based off hparams
    ds = hparams.data.name
    layers = hparams.model.depth
    i = hparams.model.dim.input
    h = hparams.model.dim.hidden
    o = hparams.model.dim.output

    encoding = f"{ds}_{layers}x{i}x{h}x{o}_{hparams.model.activation}_{hparams.loss}"

    return f"{encoding}_seed-{hparams.random_seed}"
