/*
 * This file belongs to the Galois project, a C++ library for exploiting parallelism.
 * The code is being released under the terms of the 3-Clause BSD License (a
 * copy is located in LICENSE.txt at the top-level directory).
 *
 * Copyright (C) 2018, The University of Texas at Austin. All rights reserved.
 * UNIVERSITY EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES CONCERNING THIS
 * SOFTWARE AND DOCUMENTATION, INCLUDING ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR ANY PARTICULAR PURPOSE, NON-INFRINGEMENT AND WARRANTIES OF
 * PERFORMANCE, AND ANY WARRANTY THAT MIGHT OTHERWISE ARISE FROM COURSE OF
 * DEALING OR USAGE OF TRADE.  NO WARRANTY IS EITHER EXPRESS OR IMPLIED WITH
 * RESPECT TO THE USE OF THE SOFTWARE OR DOCUMENTATION. Under no circumstances
 * shall University be liable for incidental, special, indirect, direct or
 * consequential damages or loss of profits, interruption of business, or
 * related expenses which may arise from use of Software or Documentation,
 * including but not limited to those resulting from defects in Software and/or
 * Documentation, or loss or inaccuracy of data of any kind.
 */

#ifdef __APPLE__
#include <opencl/opencl.h>
#else
extern "C" {
#include "CL/cl.h"
};
#endif

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <sys/stat.h>
#include <assert.h>
#include <math.h>

//#define _GOPT_CL_ENABLE_PROFILING_ 1 //to enable profiling (slower).
#ifndef CL_DEVICE_MANAGER_H_
#define CL_DEVICE_MANAGER_H_

/*
 #define AMD_OCL_COMPILE_OPTIONS "" //"-O3 -x clc++ -I."
 #define ACTIVE_OCL_COMPILE_OPTIONS AMD_OCL_COMPILE_OPTIONS
 */
namespace galois {
namespace opencl {
struct CL_Platform;
struct OpenCL_Setup;
} // namespace opencl
} // namespace galois

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "CL_DeviceStats.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "CL_Device.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "CL_Platform.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "CL_Context.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#include "CL_DeviceSet.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "CL_Kernel.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
namespace galois {
namespace opencl {
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
template <typename T>
void CL_Device::init_on_device(cl_mem arr, size_t sz, const T& val) {
#if _GALOIS_BUILD_INITIALIZER_KERNEL_
  galois::opencl::CHECK_CL_ERROR(
      clSetKernelArg(init_kernel, 0, sizeof(cl_mem), &arr),
      "Arg, compact is NOT set!");
  galois::opencl::CHECK_CL_ERROR(
      clSetKernelArg(init_kernel, 1, sizeof(int), (void*)&sz),
      "Arg, compact is NOT set!");
  galois::opencl::CHECK_CL_ERROR(
      clSetKernelArg(init_kernel, 2, sizeof(int), (void*)&val),
      "Arg, compact is NOT set!");
  size_t local =
      galois::opencl::OpenCL_Setup::workgroup_size(init_kernel, this);
  size_t global = (size_t)(ceil(sz / ((double)local)) * local);
  galois::opencl::CHECK_CL_ERROR(
      clEnqueueNDRangeKernel(this->command_queue(), init_kernel, 1, NULL,
                             &global, &local, 0, NULL, NULL),
      "Failed init");
#endif
} // End CL_Device::init_on_device
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

} // namespace opencl
} // namespace galois
#endif /* CL_DEVICE_MANAGER_H_ */
