/*
 * This file belongs to the Galois project, a C++ library for exploiting parallelism.
 * The code is being released under the terms of the 3-Clause BSD License (a
 * copy is located in LICENSE.txt at the top-level directory).
 *
 * Copyright (C) 2018, The University of Texas at Austin. All rights reserved.
 * UNIVERSITY EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES CONCERNING THIS
 * SOFTWARE AND DOCUMENTATION, INCLUDING ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR ANY PARTICULAR PURPOSE, NON-INFRINGEMENT AND WARRANTIES OF
 * PERFORMANCE, AND ANY WARRANTY THAT MIGHT OTHERWISE ARISE FROM COURSE OF
 * DEALING OR USAGE OF TRADE.  NO WARRANTY IS EITHER EXPRESS OR IMPLIED WITH
 * RESPECT TO THE USE OF THE SOFTWARE OR DOCUMENTATION. Under no circumstances
 * shall University be liable for incidental, special, indirect, direct or
 * consequential damages or loss of profits, interruption of business, or
 * related expenses which may arise from use of Software or Documentation,
 * including but not limited to those resulting from defects in Software and/or
 * Documentation, or loss or inaccuracy of data of any kind.
 */

#ifndef SPARSELU_H
#define SPARSELU_H

#define EPSILON 1.0E-6

int checkmat(float* M, float* N);
void genmat(float* M[]);
void print_structure(char* name, float* M[]);
float* allocate_clean_block();
void lu0(float* diag);
void bdiv(float* diag, float* row);
void bmod(float* row, float* col, float* inner);
void fwd(float* diag, float* col);

#ifdef __cplusplus
extern "C" {
#endif
void sparselu_init(float*** pBENCH, char* pass);
void sparselu(float** BENCH);
void sparselu_fini(float** BENCH, char* pass);

void sparselu_seq_call(float** BENCH);
void sparselu_par_call(float** BENCH);

int sparselu_check(float** SEQ, float** BENCH);
#ifdef __cplusplus
}
#endif

#endif
