set -x

code_root=../MetaResearcher

pip config set global.index-url https://pkgs.d.xiaomi.net/artifactory/api/pypi/pypi-virtual/simple
pip config set global.extra-index-url https://pkgs.d.xiaomi.net/artifactory/api/pypi/pypi-virtual/simple
pip config set install.trusted-host pkgs.d.xiaomi.net
pip config set global.trusted-host pkgs.d.xiaomi.net

export WANDB_MODE="offline"
export WANDB_API_KEY="XXXXXXXXXXXXXXXXXXXXX"
export HF_ENDPOINT=https://hf-mirror.com
export VLLM_ATTENTION_BACKEND=XFORMERS
export BASE_MODEL='../QwQ-32B'
export PROJECT_NAME='MetaResearcher'
export EXPERIMENT_NAME='grpo-metaesearcher-qwq-32b-glaive-tool'

export TENSORBOARD_DIR="${code_root}/logs/tensorboard/${EXPERIMENT_NAME}"

cd "${code_root}"
pip install ray==2.44.0
pip install faiss-cpu
pip install FlagEmbedding

export SEARCH_ENGINES="XXXX"
export SEARCH_BASE_URL="XXXX"
export OPTIONAL_SEARCH_ENGINE="XXXX"


if [[ "${RANK}" = "0" ]]; then
    ray start --head --port 6379
    while true; do
        sleep 5  
        node_count=$(ray status | grep -c 'node_')  
        if [[ "$node_count" -eq "$WORLD_SIZE" ]]; then
            bash ../train_bash/MutiNode_ToolCall_qwq32B_grpo_researcher_glaive_tool.sh
            break
        else
            echo "Current Node：$node_count / $WORLD_SIZE"
        fi
    done
else
    ray start --address=${MASTER_ADDR}:6379
    sleep inf
fi