from openai import OpenAI
from pipeline.evaluator.abstract_evaluator import Evaluator
from const import COST_DICT
import re
from typing import Literal

from pipeline.utils import print_colored

class OpenAIEvaluator(Evaluator):
    def __init__(self, api_key, model_id: Literal["gpt-4-turbo-2024-04-09", "gpt-4-0125-preview", "gpt-3.5-turbo"] = "gpt-4-0125-preview"):
        self.api_key = api_key
        self.temperature = 0 # default temperature is 1
        self.api = OpenAI(base_url = "https://api.gptsapi.net/v1") # use wildcard domain
        # self.api = OpenAI()
        self.model =  model_id # "gpt-4-turbo-2024-04-09" # "gpt-4-0125-preview"
        #TODO: pass model config (model, cache_dir, temperature) as config dict

    def decision_extract(self, last_msg):
        last_msg = last_msg.lower()
        re_expr = r'\b(?:\*\*decision\*\*:\s*|decision:\s*)?(\*\*(success|partially|partial|failed|fail)\*\*|(success|partially|partial|failed|fail))\b'
        # re_expr = r'\b(?:decision:\s*)?(\*\*(success|partially|partial|failed|fail)\*\*|success|partially|partial|failed|fail)\b'
        matches = re.findall(re_expr, last_msg, re.IGNORECASE)
        print(last_msg)
        print(matches)
        
        if matches:
            # We take the last match in the list of matches
            last_decision = matches[-1]
            for mt in last_decision:
                if len(mt) == 0:
                    continue
                else:
                    last_decision = mt.strip('*').lower()  # Strip '*' for cases where the word is bolded
                    break
            
            # The order here is important 'partially success' will become 'partially'
            if "partial" in last_decision: 
                return "partially"
            elif "success" in last_decision:
                return "success"
            elif "fail" in last_decision:
                return "failed"
        else:
            print_colored("========No matching decision========", "red")
            return None
        

    def _generate_response(self, system_msg, user_msg):
        input_message=[
            {"role": "system", "content": system_msg},
            {"role": "user", "content": user_msg},
        ]
        response = self.api.chat.completions.create(
            model=self.model,
            messages=input_message,
            temperature=self.temperature,
        )         
        completion_cost= response.usage.completion_tokens * COST_DICT[self.model]["output"] / 1000
        prompt_cost = response.usage.prompt_tokens * COST_DICT[self.model]["input"] / 1000
        response = response.choices[-1].message.content
        cost = completion_cost + prompt_cost
        return response, cost