"""
run this script to get the text input to prepare for baseline Curator

"""
from collections import OrderedDict
import os
import json
from unittest import case
base_dir = (os.path.dirname(os.path.abspath(__file__)))

PROPMT_PATH = "prompts/response_placeholder_wo_docs.txt"
DEST_DIR = "files"

def print_info(scenario,file_id, hint, level):

    HEADER = '\033[95m'
    OKCYAN = '\033[96m'
    OKGREEN = '\033[92m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'

    print(f'{HEADER}Scenario: {scenario}{ENDC}')
    print(f'{OKCYAN}File ID: {file_id}{ENDC}')
    print(f'{OKGREEN}Level {level} hint: {hint}{ENDC}')
    print(f'{BOLD}{"-" * 50}{ENDC}')
    
def load_human_labels(path = None):
    """
    This function is to load the 92 human labeled test cases, in a set of 2-tuple (file_id, hint_level)
    The label is in the format of json, please see `label.json` under the same directory for the format
    """
    if path is None:
        path = os.path.join(base_dir, "label.json")
    
    with open(path, "r") as f:
        labels = json.load(f)
    
    res = set()
    
    for hint_level, item in labels.items():
        for _, case_list in item.items():
            for case in case_list:
                res.add((case["id"], hint_level))
    
    return res



def get_input():
    from benchmark.api import BenchmarkManager
    manager = BenchmarkManager()
    
    res = dict()

    scenarios = manager.get_scenarios()
    

    for scenario in scenarios:
        res[scenario] = OrderedDict()

        file_ids = manager.list_file_ids(scenario)
        
        for file_id in file_ids:
            res[scenario][file_id] = []
            hints, dataset_files, _ = manager.get_test_case_info(id = file_id, dest_dir=DEST_DIR, use_doc=False) # Return doc_path

            for k, hint in enumerate(hints):
                i = k - 1
                print_info(scenario, file_id, hint, level = i)
                    
                with open(PROPMT_PATH, "r") as f:
                    input = f.read()
                    
                assert type(hint) == str
                input = input.replace("<HINT>", str(hint)).replace("<UPLOAD_DATASET>", str(dataset_files))
                manager.write_input(scenario, file_id, i, input)
                continue
        
if __name__ == "__main__":
    get_input()
        
    
