import json

import os
from benchmark.api import BenchmarkManager

from pipeline.utils import get_user_input, get_user_input_multiline, print_colored


# data_path = "benchmark_hard.json"

# with open(data_path, "r") as f:
#     data = json.load(f)
    
def make_label_file(path = None):
    """
    This is the function to make the human labeled test cases into the same format as the benchmark_hard.json
    {
    "hint_level": {
    "scenario": [
      {
          "id": "file_id",
        },
        {}, ...
        ]
    } ,
    ...
    }  
    """
    with open(path, "r") as f:
        labels = json.load(f)
    
    to_annotate_list = []
    
    for hint_level, item in labels.items():
        for scenario, case_list in item.items():
            for case in case_list:
                id = case["id"]
                to_annotate_list.append([scenario, id, hint_level])
    
    with open("pipeline/webpage.json", "w") as f:
        json.dump(to_annotate_list, f, indent=4)
        
    return to_annotate_list
        
data = make_label_file(path ="pipeline/label.json")

                
    
def main(loop = True):
    base_path = 'benchmark/platforms'
    manager = BenchmarkManager()
    
    print_colored("Choose the webpage model to evaluate", 'yellow')
    model = get_user_input("Enter the model name: ")
    
    save_dir = f"pipeline/output/webpage-{model}-hard"
    from tqdm import tqdm
    if loop:
        for (scenario, id, hint_level) in tqdm(data, total = len(data), desc="Progress"):
            issue = manager.get_issue_context(id=id)
            save_path = "{}/{}/{}".format(save_dir,scenario, id)
            hint_save_path = "{}/{}/{}/{}".format(save_dir,scenario, id, f"hint_level_{hint_level}")
            if os.path.exists(hint_save_path):
                print_colored("Skipping scenario: {} | File ID: {} | hint Level: {}".format(scenario, id, hint_level), 'yellow')
                continue
                
            hints = manager.get_hints(id=id)

            hint_level = int(hint_level)
            if hint_level == -1:
                hint = "None"
            else:
                hint = hints[int(hint_level)]
            print_colored(f"Scenario: {scenario} | File ID: {id} | hint Level: {hint_level}", 'yellow')
            issue = issue.replace(r'\n', '\n').replace('\\',"")
            print("\n")
            print(issue)
            print("\n")
            
            print("\n")
            print("hint is: ",hint)
            print("\n")
            
                
            with open ("prompts/evaluate_with_metrics.txt", "r") as f:
                prompt_with_metrics = f.read()

            print_colored(f"Please find the file in {base_path}/{scenario}/files/{id}/", 'cyan')
            print_colored(f"Please find the input in {base_path}/{scenario}/input/{id}/input_with_hint_{hint_level}.txt", 'cyan')
            
            answer = get_user_input_multiline("Enter the answer from ChatGPT: ")
            
            os.makedirs(hint_save_path, exist_ok=True)

            prompt_with_metrics = prompt_with_metrics.replace("<ANSWER>", answer).replace("<ISSUE>", issue).replace("<HINT>", hint)

            
            with open ("{}/output.txt".format(hint_save_path), "w") as f:
                f.write(answer)
                
            with open ("{}/issue.txt".format(save_path), "w") as f:
                f.write(issue)

                
            print_colored("Completed hint level: " + str(hint_level), 'green')
            print("\n\n")
    

if __name__ == "__main__":
    main()
