from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': sample_steps,
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'reference_path': 'PATH/cifar10-32x32-train.npz',
        'model_name': 'edm-cifar10-32x32-uncond-vp',
        'model_path': f'PATH/results/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-417e381f-0171-451b-9dc1-c779895358c5.0/checkpoints/100000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'output_save_path': f'results_fid/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-417e381f-0171-451b-9dc1-c779895358c5.0/checkpoints/100000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 18], [0, 1, 18], [0, 1, 2, 18], [0, 3, 5, 18], [0, 1, 3, 5, 18]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, round(2 / 3, 5)))
    return configs
