import pickle
from typing import Callable

import numpy as np

from .config import get_config


def get_values(filepath_func: Callable[[int], str]) -> list[float]:
    values = []
    for i in range(10):
        with open(filepath_func(i), 'rb') as file:
            value: float = pickle.load(file)
            values.append(value)
    return values


def main() -> None:
    for sample_steps in [
        [0, 18],
        [0, 1, 18],
        [0, 1, 2, 18],
        [0, 3, 5, 18],
        [0, 1, 3, 5, 18]
    ]:
        values = get_values(lambda i: get_config(i, sample_steps, round(0.75, 5))['output_save_path'])
        print(sample_steps, 'min', round(np.min(values), 3))
        print(sample_steps, 'max', round(np.max(values), 3))
        print(sample_steps, 'mean', round(np.mean(values), 3))
        print(sample_steps, 'std', round(np.std(values), 3))
        print()


if __name__ == '__main__':
    main()
