from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': sample_steps,
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'reference_path': 'PATH/cifar10-32x32-train.npz',
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_path': f'PATH/results/lines-gan-cifar10-32x32-12-bs-32-br-16-single-step-ef58396f-91a4-4bd8-9b8f-1939f23b2826.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'num_classes': 10,
        'output_save_path': f'results_fid/lines-gan-cifar10-32x32-12-bs-32-br-16-single-step-ef58396f-91a4-4bd8-9b8f-1939f23b2826.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 18]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, 0.75))
    return configs
