from typing import Any


def get_config_single_step(index: int) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': [0, 18],
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'reference_path': 'PATH/fid-refs/cifar10-32x32.npz',
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_path': 'PATH/results/lines-gan-cifar10-32x32-second-phase-05ef73aa-049f-4158-b266-72ee8b07423b_[0,1,18]-12-bs-32-br-16-373b74fb-f6c6-4109-a0af-6677221ef783.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth',
        'num_classes': 10,
        'output_save_path': f'results_fid/lines-gan-cifar10-32x32-second-phase-05ef73aa-049f-4158-b266-72ee8b07423b_[0,1,18]-12-bs-32-br-16-373b74fb-f6c6-4109-a0af-6677221ef783.0/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667/[0,18]/{index}.pickle'
    }


def get_config_two_steps(index: int) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': [0, 1, 18],
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'reference_path': 'PATH/fid-refs/cifar10-32x32.npz',
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_path': 'PATH/results/lines-gan-cifar10-32x32-second-phase-05ef73aa-049f-4158-b266-72ee8b07423b_[0,1,18]-12-bs-32-br-16-373b74fb-f6c6-4109-a0af-6677221ef783.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth',
        'num_classes': 10,
        'output_save_path': f'results_fid/lines-gan-cifar10-32x32-second-phase-05ef73aa-049f-4158-b266-72ee8b07423b_[0,1,18]-12-bs-32-br-16-373b74fb-f6c6-4109-a0af-6677221ef783.0/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667/[0,1,18]/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    return [get_config_single_step(i) for i in range(10)] + [get_config_two_steps(i) for i in range(10)]
