from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 40,
        'time_steps': sample_steps,
        'image_height': 64,
        'image_width': 64,
        'image_channels': 3,
        'reference_path': 'PATH/imagenet-64x64-edm.npz',
        'model_name': 'edm-imagenet-64x64-cond-adm',
        'model_path': f'PATH/results/lines-gan-imagenet-64x64-8-bs-16-br-32-441ae9f7-3974-42e9-b73a-9859b373b844.0/checkpoints/last/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'num_classes': 1000,
        'output_save_path': f'results_fid/lines-gan-imagenet-64x64-8-bs-16-br-32-441ae9f7-3974-42e9-b73a-9859b373b844.0/last/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle',
        'batch_size': 10
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 40], [0, 1, 40], [0, 1, 2, 40], [0, 3, 5, 40]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, 0.75))
    return configs
