from typing import Any


def get_config(
        model_name: str,
        model_load_path: str,
        num_steps: int,
        time_steps: list[int],
        num_classes: int,
        image_height: int,
        image_width: int,
        image_channels: int,
        reference_path: str,
        num_samples: int = 50_000,
        batch_size: int = 50,
        noises_folder: str = None,
        labels_folder: str = None,
        save_path: str = None,
        start_noise_index: int = 0,
        start_label_index: int = 0,
        sigma_min: float = 0.002,
        sigma_max: float = 80.0,
        rho: float = 7.0,
        s_churn: float = 0.0,
        s_min: float = 0.0,
        s_max: float = float('inf'),
        s_noise: float = 1.0,
        model_load_keys: list[str] = None,
        multiply_noises: bool = True,
        same_noise: bool = True,
        n_processes: int = 8,
        device: str = None
) -> dict[str, Any]:
    return {
        'num_steps': num_steps,
        'time_steps': time_steps,
        'model_name': model_name,
        'model_load_path': model_load_path,
        'num_classes': num_classes,
        'image_height': image_height,
        'image_width': image_width,
        'image_channels': image_channels,
        'reference_path': reference_path,
        'num_samples': num_samples,
        'batch_size': batch_size,
        'noises_folder': noises_folder,
        'labels_folder': labels_folder,
        'save_path': save_path,
        'start_noise_index': start_noise_index,
        'start_label_index': start_label_index,
        'sigma_min': sigma_min,
        'sigma_max': sigma_max,
        'rho': rho,
        's_churn': s_churn,
        's_min': s_min,
        's_max': s_max,
        's_noise': s_noise,
        'model_load_keys': model_load_keys,
        'multiply_noises': multiply_noises,
        'same_noise': same_noise,
        'n_processes': n_processes,
        'device': device
    }
