from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 40,
        'time_steps': sample_steps,
        'image_height': 64,
        'image_width': 64,
        'image_channels': 3,
        'calculate_fid': True,
        'calculate_isc': True,
        'fid_reference_path': 'PATH/fid-refs/afhqv2-64x64.npz',
        'model_name': 'edm-afhqv2-64x64-uncond-vp',
        'model_path': f'PATH/results/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-0fd31e38-e3b7-40d2-9862-d5eb3cb3e0e0.0/checkpoints/50000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'fid_save_path': f'results_fidelity/fid/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-0fd31e38-e3b7-40d2-9862-d5eb3cb3e0e0.0/checkpoints/50000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle',
        'isc_save_path': f'results_fidelity/isc/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-0fd31e38-e3b7-40d2-9862-d5eb3cb3e0e0.0/checkpoints/50000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 40], [0, 1, 40], [0, 1, 2, 40], [0, 3, 5, 40]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, round(2 / 3, 5)))
    return configs
