from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': sample_steps,
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'calculate_fid': True,
        'calculate_isc': True,
        'fid_reference_path': 'PATH/fid-refs/cifar10-32x32.npz',
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_path': f'PATH/results/lines/lines-cifar10-32x32-2-loss-l2-bs-256-br-2-5811a473-b01f-4ca6-b614-03ffa5c7bd92/checkpoints/last.converted/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'num_classes': 10,
        'fid_save_path': f'results_fidelity/fid/lines-cifar10-32x32-2-loss-l2-bs-256-br-2-5811a473-b01f-4ca6-b614-03ffa5c7bd92/checkpoints/last/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle',
        'isc_save_path': f'results_fidelity/isc/lines-cifar10-32x32-2-loss-l2-bs-256-br-2-5811a473-b01f-4ca6-b614-03ffa5c7bd92/checkpoints/last/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 18], [0, 1, 18], [0, 1, 2, 18], [0, 3, 5, 18], [0, 1, 3, 5, 18]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, round(2 / 3, 5)))
    return configs
