from typing import Any


def get_config(index: int, sample_steps: list[int], ema_power: float) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': sample_steps,
        'image_height': 32,
        'image_width': 32,
        'image_channels': 3,
        'calculate_fid': True,
        'calculate_isc': True,
        'fid_reference_path': 'PATH/fid-refs/cifar10-32x32.npz',
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_path': f'PATH/results/lines-gan-cifar10-32x32-10-bs-32-br-16-05ef73aa-049f-4158-b266-72ee8b07423b.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}.pth',
        'num_classes': 10,
        'fid_save_path': f'results_fidelity/fid/lines-gan-cifar10-32x32-10-bs-32-br-16-05ef73aa-049f-4158-b266-72ee8b07423b.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle',
        'isc_save_path': f'results_fidelity/isc/lines-gan-cifar10-32x32-10-bs-32-br-16-05ef73aa-049f-4158-b266-72ee8b07423b.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_{ema_power}/{"[" + str(",".join(map(str, sample_steps))) + "]"}/{index}.pickle'
    }


def get_configs() -> list[dict[str, Any]]:
    configs: list[dict[str, Any]] = []
    for sample_steps in [[0, 18], [0, 1, 18], [0, 1, 2, 18], [0, 3, 5, 18], [0, 1, 3, 5, 18]]:
        for index in range(10):
            configs.append(get_config(index, sample_steps, 0.75))
    return configs
