import pickle
from typing import Callable

import numpy as np

from .config import get_config


def get_values(filepath_func: Callable[[int], str]) -> list[float]:
    values = []
    for i in range(10):
        with open(filepath_func(i), 'rb') as file:
            value: float = pickle.load(file)
            values.append(value)
    return values


def main() -> None:
    for sample_steps in [[0, 40], [0, 1, 40], [0, 1, 2, 40], [0, 3, 5, 40]]:
        values = get_values(lambda i: get_config(i, sample_steps, 0.75)[f'fid_save_path'])
        print(sample_steps, 'fid', 'min', round(np.min(values), 3))
        print(sample_steps, 'fid', 'max', round(np.max(values), 3))
        print(sample_steps, 'fid', 'mean', round(np.mean(values), 3))
        print(sample_steps, 'fid', 'std', round(np.std(values), 3))
        print()
    for sample_steps in [[0, 40], [0, 1, 40], [0, 1, 2, 40], [0, 3, 5, 40]]:
        values = get_values(lambda i: get_config(i, sample_steps, 0.75)[f'isc_save_path'])
        print(sample_steps, 'is', values[0])
        # print(sample_steps, 'is', 'min', round(values[0], 3))
        # print(sample_steps, 'is', 'max', round(values[0], 3))
        # print(sample_steps, 'is', 'mean', round(np.mean(values), 3))
        # print(sample_steps, 'is', 'std', round(np.std(values), 3))
        # print()


if __name__ == '__main__':
    main()
