import argparse
from typing import Any

from scripts.plots.scripts.samples.main_single_step_conditional import run as run_single_step_conditional
from utils.logger.logger import Logger
from utils.utils import get_class_name


def run(
        name: str,
        seed_entropy_noises: int = None,
        seed_entropy_labels: int = None
) -> None:
    Logger.debug(
        f'{get_class_name(run)} - '
        f'name: {name}, seed_entropy_noises: {seed_entropy_noises}, seed_entropy_labels: {seed_entropy_labels}'
    )
    run_single_step_conditional(
        name=name,
        model_name='edm-imagenet-64x64-cond-adm',
        gan_model_path='PATH/results/lines-gan-imagenet-64x64-14-bs-16-br-32-two-step-fcfc49fd-3236-4672-a3ac-94aa64050860.0/checkpoints/last/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_1.0.pth',
        save_folder='samples-plot-conditional',
        image_height=64,
        image_width=64,
        image_channels=3,
        num_samples=100,
        rows=10,
        cols=10,
        num_steps=40,
        batch_size=50,
        num_classes=1000,
        seed_entropy_noises=seed_entropy_noises,
        seed_entropy_labels=seed_entropy_labels,
        num_processes=8
    )
    Logger.debug(f'{get_class_name(run)} - done')


def run_from_config(config: dict[str, Any]) -> None:
    run(**config)


def parse_args() -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument('--name', type=str, required=True)
    parser.add_argument('--seed_entropy_noises', type=int, default=None)
    parser.add_argument('--seed_entropy_labels', type=int, default=None)
    return parser.parse_args()


def get_config_from_args(args: argparse.Namespace) -> dict[str, Any]:
    return vars(args)


def main() -> None:
    args = parse_args()
    config = get_config_from_args(args)
    run_from_config(config)


if __name__ == '__main__':
    main()
