from typing import Any

num_runs: int = 21
samples_per_run: int = 50_000


def get_config(index: int) -> dict[str, Any]:
    return {
        'num_steps': 18,
        'time_steps': [0, 1, 18],
        'model_name': 'edm-cifar10-32x32-cond-vp',
        'model_load_path': 'PATH/results/lines-gan-cifar10-32x32-10-bs-32-br-16-05ef73aa-049f-4158-b266-72ee8b07423b.0/checkpoints/10000/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth',
        'noises_folder': 'PATH-2/cifar10-32x32/second-phase/noises',
        'labels_folder': 'PATH-2/cifar10-32x32/second-phase/labels',
        'output_folder': 'PATH-2/cifar10-32x32/second-phase/05ef73aa-049f-4158-b266-72ee8b07423b_[0,1,18]',
        'num_samples': samples_per_run,
        'batch_size': 200,
        'num_classes': 10,
        'start_noise_index': index * samples_per_run,
        'start_label_index': index * samples_per_run,
        'start_output_index': index * samples_per_run
    }


def get_configs() -> list[dict[str, Any]]:
    return [get_config(i) for i in range(num_runs)]
