import argparse
from typing import Any

from .config import get_configs
from src.fid_utils.inference.multi_step import run_from_config as run_inference_multi_step


def run(index: int) -> None:
    configs: list[dict[str, Any]] = get_configs()
    run_inference_multi_step(configs[index])


def run_from_config(config: dict[str, Any]) -> None:
    run(**config)


def parse_args() -> argparse.Namespace:
    parser: argparse.ArgumentParser = argparse.ArgumentParser()
    parser.add_argument('--index', type=int, required=True)
    return parser.parse_args()


def get_config_from_args(args: argparse.Namespace) -> dict[str, Any]:
    return vars(args)


def main() -> None:
    args: argparse.Namespace = parse_args()
    config: dict[str, Any] = get_config_from_args(args)
    run_from_config(config)


if __name__ == '__main__':
    main()
