#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/discriminator-cifar10-32x32-1-bs-512-br-1-7c15e9ca-1452-4853-b104-3ef50a21b1c7-%j.out
#SBATCH --error=runs/errors/discriminator-cifar10-32x32-1-bs-512-br-1-7c15e9ca-1452-4853-b104-3ef50a21b1c7-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

moudle load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.discriminator_distributed --config_filepath configs/discriminator-cifar10-32x32-1-bs-512-br-1-7c15e9ca-1452-4853-b104-3ef50a21b1c7.json
