#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/discriminator-cifar10-32x32-2-bs-512-br-1-7237aaae-dcdc-4fae-ad40-89690944b10b-%j.out
#SBATCH --error=runs/errors/discriminator-cifar10-32x32-2-bs-512-br-1-7237aaae-dcdc-4fae-ad40-89690944b10b-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.discriminator \
  --config_filepath configs/discriminator-cifar10-32x32-2-bs-512-br-1-7237aaae-dcdc-4fae-ad40-89690944b10b.json \
  --distributed \
  --retries 3
