import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/cifar10-32x32'
base_real_data: str = 'PATH'
base_results: str = 'results'
num_sample_steps: int = 18

base_load_path: str = 'PATH/results/lines-gan-cifar10-32x32-2-bs-32-br-16-pretrained-discriminator-a1f6c7f6-e641-4299-9f06-93da7ba955aa/checkpoints/last'

def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 512,
        'batch_repeats': 1,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 500,
        'dataset': {'dataset_name': 'cifar10-32x32'},
        'report': {'train_steps': 50, 'test_steps': None},
        'checkpoint': {
            'save_steps': 100_000,
            'last_steps': 2_500
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-cifar10-32x32-cond-vp',
            'load_path': f'{base_load_path}/model.pth.tmp'
        },
        'discriminator': {
            'conditional': True
        },
        'discriminator_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.002,
            'params': {'betas': (0.5, 0.9)}
        },
        'amp': {},
        'distributed_sampler_seed': np.random.randint(0, 2 ** 31),
        'distributed_sampler_real_seed': np.random.randint(0, 2 ** 31),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-cond-vp',
                    'num_samples': 1_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 1_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 10,
                    'start_index': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-cond-vp',
                    'num_samples': 10,
                    'start_index': 1_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 10,
                    'start_index': 1_000_000
                },
                'time_step': 0
            }
        ],
        'train_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/train/images',
                    'num_samples': 50_000
                },
                'label': {
                    'folder': f'{base_real_data}/train/labels',
                    'num_samples': 50_000
                }
            }
        ],
        'test_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/test/images',
                    'num_samples': 10_000
                },
                'label': {
                    'folder': f'{base_real_data}/test/labels',
                    'num_samples': 10_000
                }
            }
        ],
    }


def main() -> None:
    name: str = 'discriminator-cifar10-32x32-3-bs-512-br-1'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
