#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/discriminator-cifar10-32x32-3-bs-512-br-1-e6577330-44ab-47fd-a6df-432a03acb27d-%j.out
#SBATCH --error=runs/errors/discriminator-cifar10-32x32-3-bs-512-br-1-e6577330-44ab-47fd-a6df-432a03acb27d-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.discriminator \
  --config_filepath configs/discriminator-cifar10-32x32-3-bs-512-br-1-e6577330-44ab-47fd-a6df-432a03acb27d.json \
  --distributed \
  --retries 3
