#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/discriminator-imagenet-64x64-1-bs-256-br-2-5090b3ed-132f-4a13-9db2-45a1d3c37f89-%j.out
#SBATCH --error=runs/errors/discriminator-imagenet-64x64-1-bs-256-br-2-5090b3ed-132f-4a13-9db2-45a1d3c37f89-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.discriminator \
  --config_filepath configs/discriminator-imagenet-64x64-1-bs-256-br-2-5090b3ed-132f-4a13-9db2-45a1d3c37f89.json \
  --distributed \
  --retries 3
