import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/imagenet-64x64'
base_real_data: str = 'PATH/datasets/imagenet-64x64'
base_results: str = 'results'
num_sample_steps: int = 40
num_train_steps: int = 20

base_load_path: str = 'PATH/results/lines-imagenet-64x64-8-loss-lpips-vgg-64-bs-32-br-64-daa24e43-b325-4e7a-81c2-244412bfadb2.0/checkpoints/last'

def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 256,
        'batch_repeats': 2,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 500,
        'dataset': {'dataset_name': 'imagenet-64x64'},
        'report': {'train_steps': 50, 'test_steps': None},
        'checkpoint': {
            'save_steps': 100_000,
            'last_steps': 2_500
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-imagenet-64x64-cond-adm',
            'load_path': f'{base_load_path}/model.pth'
        },
        'discriminator': {
            'conditional': True
        },
        'discriminator_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.002,
            'params': {'betas': (0.5, 0.9)}
        },
        'amp': {},
        'distributed_sampler_seed': np.random.randint(0, 2 ** 31),
        'distributed_sampler_real_seed': np.random.randint(0, 2 ** 31),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 4_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 4_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 4_000_000
                },
                'time_step': i
            } for i in range(num_train_steps)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 10,
                    'start_index': 5_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 10,
                    'start_index': 5_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 10,
                    'start_index': 5_000_000
                },
                'time_step': 0
            }
        ],
        'train_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/images',
                    'num_samples': 1281167
                },
                'label': {
                    'folder': f'{base_real_data}/labels',
                    'num_samples': 1281167
                }
            }
        ]
    }


def main() -> None:
    name: str = 'discriminator-imagenet-64x64-2-bs-256-br-2'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
