#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/discriminator-imagenet-64x64-2-bs-256-br-2-6cc71ae5-5ae6-49f1-8a88-5653efb80b2c-%j.out
#SBATCH --error=runs/errors/discriminator-imagenet-64x64-2-bs-256-br-2-6cc71ae5-5ae6-49f1-8a88-5653efb80b2c-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.discriminator \
  --config_filepath configs/discriminator-imagenet-64x64-2-bs-256-br-2-6cc71ae5-5ae6-49f1-8a88-5653efb80b2c.json \
  --distributed \
  --retries 3
